// w systemie wprowadzamy trzy nowe zmienne z nastpujcymi wartociami
// OMP_NUM_THREADS : 2
// OMP_DYNAMIC : TRUE
// OMP_NESTED : FALSE

#include <iostream>
#include <locale.h> // pozwoli drukowa polskie znaki na konsoli
#include <omp.h> // Plik nagkowy niezbdny do uruchamiania programw z OpenMP 
#include "stdafx.h"

int main( int argc, char* argv[])
{
	setlocale( LC_ALL, "Polish" ); // Polska lokalizacja, w szczeglnoci znaki
	std::cout << " ------------------ ex1 ------------------------\n";
  	omp_set_dynamic(0);
	omp_set_nested(1);
	omp_set_num_threads(3);
	#pragma omp parallel num_threads(4)
	{
		int tid = omp_get_thread_num();
		int nth = omp_get_num_threads();
		std::cout<< "T lini napisa wtek nr " << tid <<" z grupy " << nth << " wtkw. " << std::endl; 
		#pragma omp parallel num_threads(3)
		{
			int tid2 = omp_get_thread_num();
			std::cout<< "T lini napisa wtek nr " << tid2 <<" dla ktrego wtkiem macierzystym jest wtek " << tid << std::endl; 
			std::cout << "#####: "<<tid<<":"<<tid2<<std::endl;
		}
	}
	std::cout << " ---------------- Koniec -----------------------\n";
  	return 0;
}
